IF OBJECT_ID ('P_EST_PROD_EST_ARV_MERCADOLOGICA_MEDIAF_ANALISE') IS NOT NULL
    BEGIN
	   DROP PROCEDURE P_EST_PROD_EST_ARV_MERCADOLOGICA_MEDIAF_ANALISE
    END
GO
CREATE PROCEDURE P_EST_PROD_EST_ARV_MERCADOLOGICA_MEDIAF_ANALISE (@CD_EMP INT,@CD_PROD INT)
AS 
set nocount on 
/*
declare 
	   @CD_EMP INT =1,
        @CD_PROD INT= 7612 
*/
	   CREATE TABLE #EST_PROD_CPL_MEDIAF_ANALISE
	   (CD_EMP                 INT,
	    CD_FILIAL              INT,
	    CD_PROD                INT,
	    CD_SIGLA			  INT,
	    CD_ARV_MERC_LINHA      INT,
	    DS_SIGLA               VARCHAR(50),
	    QTDE_MEDIAF            MONEY,
	    QTDE_MEDIAP            MONEY,
	    ESEG                   MONEY,
	    EMAX                   MONEY,
	    DT_NASC                DATETIME,
	    QTDE_MES_VENDA_FECHADO INT,
	    QTDE_FACEAMENTO        MONEY,
	    VALID_QTDE_FACEAMENTO  DATETIME,
	    QT_EST                 MONEY,
	    QT_EST_EM_TERC         MONEY,
	    QT_EST_DE_TERC         MONEY,
	    QT_PEND_ENT            MONEY,
	    QT_PEND_SAI            MONEY,
	    DS_GRP_PARAM           VARCHAR(50),
	    FREAV_MEDIAF_ULT_ATU   DATETIME,
	    FREAV_MEDIAF           INT,
	    NM_GRUPO_RESSUP        VARCHAR(50),
	    FRESSUP_ULT_ATU        DATETIME,
	    FRESSUP                INT,
	    MEDIA_F_LIBERADA       INT,
	    DS_ARV_PARAM           VARCHAR(250),
	    FCURVA_ULT_ATU         DATETIME,
	    FCURVA                 INT,
	    FLAG_OPERADOR_LOG      INT,
	    FILIAL_MTZ             INT,
	    QTDE_FINANCIADO        MONEY,
	    QTDE_LIMITADOR         MONEY,
	    STS_PROD_FILIAL        INT,
	    FLAG_VENDA_PERIODICA   INT,
	    FLAG_VENDA_CONSIGNADA  INT,
	    ESPECIE_FILIAL         INT,
	    STS_PROD               VARCHAR(10),
	    FALTA_CRONICA          INT,
	    QT_VD_ATUAL            MONEY,
	    QT_VD_MES1             MONEY,
	    QT_VD_MES2             MONEY,
	    QT_VD_MES3             MONEY
	   );

INSERT INTO #EST_PROD_CPL_MEDIAF_ANALISE
       SELECT DISTINCT
              E.CD_EMP AS CD_EMP,
              e.CD_FILIAL AS CD_FILIAL,
              E.CD_PROD AS CD_PROD,
		    e.CD_SIGLA,
		    L.CD_ARV_MERC_LINHA,
              '' AS DS_SIGLA,
              ISNULL(EST_PROD_CPL_MEDIAF.QTDE_MEDIAF, 0) AS QTDE_MEDIAF,
              0 AS QTDE_MEDIAP,
              ISNULL(e.ESEG, 0) AS ESEG,
              ISNULL(e.EMAX, 0) AS EMAX,
              E.DT_NASC,
              ISNULL(E.QTDE_MES_VENDA_FECHADO, 0) AS QTDE_MES_VENDA_FECHADO,
              EST_PROD_CPL_MEDIAF.QTDE_FACEAMENTO,
              EST_PROD_CPL_MEDIAF.VALID_QTDE_FACEAMENTO,
              ISNULL(E.QT_EST, 0) AS QT_EST,
              ISNULL(E.QT_EST_EM_TERC, 0) AS QT_EST_EM_TERC,
              ISNULL(E.QT_EST_DE_TERC, 0) AS QT_EST_DE_TERC,
              ISNULL(E.QT_PEND_ENT, 0) AS QT_PEND_ENT,
              ISNULL(E.QT_PEND_SAI, 0) AS QT_PEND_SAI,
              '' AS DS_GRP_PARAM,
              '' AS FREAV_MEDIAF_ULT_ATU,
              '' AS FREAV_MEDIAF,
              '' AS NM_GRUPO_RESSUP,
              '' AS FRESSUP_ULT_ATU,
              '' AS FRESSUP,
              ISNULL(E.MEDIA_F_LIBERADA, 0) AS MEDIA_F_LIBERADA,
              '' AS DS_ARV_PARAM,
              '' AS FCURVA_ULT_ATU,
              '' AS FCURVA,
              PRC_FILIAL.FLAG_OPERADOR_LOG,
              PRC_FILIAL.FILIAL_MTZ,
              EST_PROD_CPL_MEDIAF.QTDE_FINANCIADO,
              EST_PROD_CPL_MEDIAF.QTDE_LIMITADOR,
              E.STS_PROD_FILIAL,
              E.FLAG_VENDA_PERIODICA,
              E.FLAG_VENDA_CONSIGNADA,
              PRC_FILIAL.ESPECIE_FILIAL,
              CASE
                  WHEN E.STS_PROD_FILIAL = 0
                  THEN 'ATIVO'
                  WHEN E.STS_PROD_FILIAL = 1
                  THEN 'INATIVO'
                  WHEN E.STS_PROD_FILIAL = 2
                  THEN 'BLOQUEADO'
                  ELSE 'BLOQUEADO'
              END STS_PROD,
              0 AS FALTA_CRONICA,
              ISNULL(EST_PROD_CPL_MEDIAF.QT_VD_ATUAL, 0) AS QT_VD_ATUAL,
              ISNULL(EST_PROD_CPL_MEDIAF.QT_VD_MES1, 0) AS QT_VD_MES1,
              ISNULL(EST_PROD_CPL_MEDIAF.QT_VD_MES2, 0) AS QT_VD_MES2,
              ISNULL(EST_PROD_CPL_MEDIAF.QT_VD_MES3, 0) AS QT_VD_MES3
       FROM V_EST_PROD_CPL_ESTOQUE E
            INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA L ON E.CD_EMP = L.CD_EMP
                                                           AND E.CD_PROD = L.CD_PROD
            LEFT JOIN EST_PROD_CPL_MEDIAF ON E.CD_EMP = EST_PROD_CPL_MEDIAF.CD_EMP
                                             AND E.CD_FILIAL = EST_PROD_CPL_MEDIAF.CD_FILIAL
                                             AND E.CD_PROD = EST_PROD_CPL_MEDIAF.CD_PROD
            LEFT OUTER JOIN PRC_FILIAL ON E.CD_EMP = PRC_FILIAL.CD_EMP
                                          AND E.CD_FILIAL = PRC_FILIAL.CD_FILIAL
       WHERE E.CD_EMP = @CD_EMP
             AND E.CD_PROD = @CD_PROD
             AND PRC_FILIAL.STS_FILIAL = 0



---------------------------------------------------------------------------------------------------------------------
update E
set 
    FALTA_CRONICA =EST_PROD_CPL_MEDIAP.FALTA_CRONICA,
    QTDE_MEDIAP =EST_PROD_CPL_MEDIAP.QTDE_MEDIAP
    from #EST_PROD_CPL_MEDIAF_ANALISE E
  INNER JOIN EST_PROD_CPL_MEDIAP ON E.CD_EMP = EST_PROD_CPL_MEDIAP.CD_EMP
                                      AND E.CD_FILIAL = EST_PROD_CPL_MEDIAP.CD_FILIAL
                                      AND E.CD_PROD = EST_PROD_CPL_MEDIAP.CD_PROD
---------------------------------------------------------------------------------------------------------------------
update E
set 
     DS_GRP_PARAM = V_EST_PROD_EST_ARV_MERCADOLOGICA.DS_GRP_PARAM ,
     FREAV_MEDIAF_ULT_ATU= V_EST_PROD_EST_ARV_MERCADOLOGICA.FREAV_MEDIAF_ULT_ATU,
    FREAV_MEDIAF= V_EST_PROD_EST_ARV_MERCADOLOGICA.FREAV_MEDIAF
    from #EST_PROD_CPL_MEDIAF_ANALISE E
    INNER JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA ON e.CD_EMP = V_EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
                                                        AND e.CD_FILIAL = V_EST_PROD_EST_ARV_MERCADOLOGICA.CD_FILIAL
                                                        AND e.CD_PROD = V_EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD
---------------------------------------------------------------------------------------------------------------------
update E
set 
      DS_SIGLA = EST_PROD_CURVA_SIGLA.DS_SIGLA
    from #EST_PROD_CPL_MEDIAF_ANALISE E
    inner JOIN EST_PROD_CURVA_SIGLA ON e.CD_EMP = EST_PROD_CURVA_SIGLA.CD_EMP
                                      AND e.CD_SIGLA = EST_PROD_CURVA_SIGLA.CD_SIGLA
---------------------------------------------------------------------------------------------------------------------
update E
set 
     NM_GRUPO_RESSUP =  V_EST_ARV_GRP_RESSUPRIMENTO.NM_GRUPO,
     FRESSUP_ULT_ATU =  V_EST_ARV_GRP_RESSUPRIMENTO.FRESSUP_ULT_ATU,
     FRESSUP	      =  V_EST_ARV_GRP_RESSUPRIMENTO.FRESSUP
    from #EST_PROD_CPL_MEDIAF_ANALISE E
    INNER JOIN V_EST_ARV_GRP_RESSUPRIMENTO ON E.CD_EMP = V_EST_ARV_GRP_RESSUPRIMENTO.CD_EMP
                                              AND E.CD_FILIAL = V_EST_ARV_GRP_RESSUPRIMENTO.CD_FILIAL
                                              AND E.CD_ARV_MERC_LINHA = V_EST_ARV_GRP_RESSUPRIMENTO.CD_ARV_MERC_LINHA
---------------------------------------------------------------------------------------------------------------------
update E
set 
      DS_ARV_PARAM =   V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL.DS_ARV_PARAM,
      FCURVA_ULT_ATU = V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL.FCURVA_ULT_ATU,
     FCURVA =		   V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL.FCURVA
    from #EST_PROD_CPL_MEDIAF_ANALISE E
    INNER JOIN V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL ON E.CD_EMP = V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL.CD_EMP
                                                                  AND E.CD_FILIAL = V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL.CD_FILIAL
                                                                  AND E.CD_PROD = V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL.CD_PROD
                                                                  AND E.CD_SIGLA = V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL.CD_SIGLA
---------------------------------------------------------------------------------------------------------------------

SELECT CD_FILIAL,
       DS_SIGLA,
       QTDE_MEDIAF,
       QTDE_MEDIAP,
       ESEG,
       EMAX,
       DT_NASC,
       QTDE_MES_VENDA_FECHADO,
       QTDE_FACEAMENTO,
       VALID_QTDE_FACEAMENTO,
       QT_EST,
       QT_EST_EM_TERC,
       QT_EST_DE_TERC,
       QT_PEND_ENT,
       QT_PEND_SAI,
       DS_GRP_PARAM,
       FREAV_MEDIAF_ULT_ATU,
       FREAV_MEDIAF,
       NM_GRUPO_RESSUP,
       FRESSUP_ULT_ATU,
       FRESSUP,
       MEDIA_F_LIBERADA,
       DS_ARV_PARAM,
       FCURVA_ULT_ATU,
       FCURVA,
       FLAG_OPERADOR_LOG,
       FILIAL_MTZ,
       QTDE_FINANCIADO,
       QTDE_LIMITADOR,
       STS_PROD_FILIAL,
       FLAG_VENDA_PERIODICA,
       FLAG_VENDA_CONSIGNADA,
       ESPECIE_FILIAL,
       STS_PROD,
       FALTA_CRONICA,
       QT_VD_ATUAL,
       QT_VD_MES1,
       QT_VD_MES2,
       QT_VD_MES3
FROM #EST_PROD_CPL_MEDIAF_ANALISE
 ORDER BY CD_FILIAL;